# Q[ԑ
# Auther:: a
# Date:: 2006/03/03
# Copyright:: Copyright (c) 2006 a(rgss-lib)

# Q[ԑуW[
module Hours

  # ԑт̐ݒ
  #
  # Jn => ["O", Tone.new(,,,邳), ω]
  #
  # PZbgɂȂĂA
  # JnԂ 0 ` 23 ̐w肷
  # ///邳  -255 ` 255 w肷.vXŖ邭,}CiXňÂȂ
  # ωԂ̒Pʂ̓t[ 20 = 1bB(603b)
  HOURS = { 6  => ["",   Tone.new( 16, 16, 16, 16), 60],
            10 => ["",   Tone.new(  0,  0,  0,  0), 60],
            17 => ["[",   Tone.new(100,  0,  0,  0), 60],
            19 => ["",   Tone.new(  0,  0, 64,-16), 60],
            23 => ["[", Tone.new(-32,-32, 64,-32), 60] }
  # ԑт`FbN郊AbԊuB
  # _w\B܂ԊuZƓ삪dȂ̂Œ
  HOURS_CHECK_DURATION = 1

  @@last_update = 0    # ŏIXV
  @@now_hours = nil    # ݂̎ԑ
  @@pause = true       # ꎞ~tO
  @@default = Tone.new(0,0,0,0) # W̃g[

  # ݂̎ԂԂ܂
  def self.now
    return GameTime.now
  end

  # ݂̎ԑіԂ܂
  def self.name
    if @@now_hours.nil?
      t = GameTime.now
      @@now_hours = self.find_hours(t.hour)
    end
    return @@now_hours[0] unless @@now_hours.nil?
    return ""
  end

  # ftHg̐FύX܂
  #
  # new_tone:: ToneCX^X
  def self.default=(new_tone)
    @@default = new_tone
    return @@default
  end

  # ݂̃ftHg̐FԂ܂
  #
  # Return:: ToneCX^X
  def self.default
    return @@default
  end

  # ԑѐJn܂
  def self.start
    self.redume(true)
  end

  # ԑѐ~܂
  def self.stop
    self.pause(true)
  end

  # ꎞ~܂B
  #
  # change_default::  truew肷ƃftHgFɂ܂
  # duration::        ftHgɂꍇ̎gpt[ł
  def self.pause(change_default = false, duration = 0)
    @@pause = true
    if change_default
      old_hours = @@now_hours
      @@now_hours = [old_hours[0], @@default, duration]
      self.start_animation(@@now_hours[1], @@now_hours[2])
    end
  end

  # ꎞ~܂B
  #
  # change_immediate::  truew肷ƑɎԑу`FbN܂
  # duration::          Ƀ`FbNꍇ̎gpt[ł
  def self.redume(change_immediate = false, duration = 0)
    if change_immediate
      now_time = GameTime.now
      now_hours = self.find_hours(now_time.hour)

      unless now_hours.nil?
        @@now_hours = now_hours
        self.start_animation(now_hours[1], duration)
        @@last_update = Time.now.to_f
      end
    end
    @@pause = false
  end

  # ԑт̃`FbNAԑтɕύXΕω܂B
  # 1t[1ĂяoĂ
  def self.update
    unless @@pause
      if Time.now.to_f >= @@last_update + self::HOURS_CHECK_DURATION
        self.check_hours
        @@last_update = Time.now.to_f
      end
    end
  end

	# ԑтω`FbN܂
	# ωĂꍇ͂̂܂
	#
	# h::      (0`23)
	# Return:: [<O:String>, <F:Tone>, <tF[ht[>]
	def self.check_hours(force = false)
		now_time = GameTime.now
		now_hours = self.find_hours(now_time.hour)

		if now_hours.nil?
			return false
		elsif @@now_hours.nil?
			@@now_hours = ["", @@default, 0]
		elsif now_hours[0] == @@now_hours[0] && !force
			return false
		end

		@@now_hours = now_hours
		self.start_animation(now_hours[1], now_hours[2])
		return true
	end

	# w莞̎ԑт擾܂
	#
	# h::      (0`23)
	# Return:: [<O:String>, <F:Tone>, <tF[ht[>]
	def self.find_hours(h)
		ret = nil
		for t in 0 .. h
			unless HOURS[h-t].nil?
				ret = HOURS[h-t]
				break
			end
		end
		if ret.nil?
			for t in 0 ... 24-h
				unless HOURS[23-t].nil?
					ret = HOURS[23-t]
					break
				end
			end
		end
		return ret
	end

	# FύX̊Jn
	#
	# new_tone:: VF(Tone)
	# duration:: t[(20 == 1b)
	def self.start_animation(new_tone, duration)
    $game_screen.start_tone_change(new_tone, duration)
	end
end

begin
	unless Hours::HOURS.size > 0
		p "Error: empty Hours.HOURS"
		exit
	end
end

# }bṽC
class Scene_Map
  #--------------------------------------------------------------------------
  #  C
  #--------------------------------------------------------------------------
  def main
    @spriteset = Spriteset_Map.new
    @message_window = Window_Message.new
    Hours.redume(true)
    Graphics.transition
    loop do
      Graphics.update
      Input.update
      Hours.update()
      update
      if $scene != self
        break
      end
    end
    Graphics.freeze
    Hours.pause(true)
    @spriteset.dispose
    @message_window.dispose
    if $scene.is_a?(Scene_Title)
      Graphics.transition
      Graphics.freeze
    end
  end
end

# Z[uf[^̓ǂݍݏ̕ύX
class Scene_Load < Scene_File
  #--------------------------------------------------------------------------
  #  Z[uf[^̓ǂݍ
  #     file : ǂݍݗpt@CIuWFNg (I[vς)
  #--------------------------------------------------------------------------
  def read_save_data(file)
    # Z[ut@C`p̃LN^[f[^ǂݍ
    characters = Marshal.load(file)
    # vCԌvp̃t[JEgǂݍ
    Graphics.frame_count = Marshal.load(file)
    GameTime.now         = Marshal.load(file)
    # eQ[IuWFNgǂݍ
    $game_system        = Marshal.load(file)
    $game_switches      = Marshal.load(file)
    $game_variables     = Marshal.load(file)
    $game_self_switches = Marshal.load(file)
    $game_screen        = Marshal.load(file)
    $game_actors        = Marshal.load(file)
    $game_party         = Marshal.load(file)
    $game_troop         = Marshal.load(file)
    $game_map           = Marshal.load(file)
    $game_player        = Marshal.load(file)
    # }WbNio[Z[uƈقȂꍇ
    # (GfB^ŕҏWĂꍇ)
    if $game_system.magic_number != $data_system.magic_number
      # }bv[h
      $game_map.setup($game_map.map_id)
      $game_player.center($game_player.x, $game_player.y)
    end
    # p[eBo[tbV
    $game_party.refresh
  end
end

# Z[uf[^̕ۑ̕ύX
class Scene_Save < Scene_File
  #--------------------------------------------------------------------------
  #  Z[uf[^̏
  #     file : ݗpt@CIuWFNg (I[vς)
  #--------------------------------------------------------------------------
  def write_save_data(file)
    # Z[ut@C`p̃LN^[f[^쐬
    characters = []
    for i in 0...$game_party.actors.size
      actor = $game_party.actors[i]
      characters.push([actor.character_name, actor.character_hue])
    end
    # Z[ut@C`p̃LN^[f[^
    Marshal.dump(characters, file)
    # vCԌvp̃t[JEg
    Marshal.dump(Graphics.frame_count, file)
    Marshal.dump(GameTime.now, file)
    # Z[u񐔂 1 ₷
    $game_system.save_count += 1
    # }WbNio[ۑ
    # (GfB^ŕۑ邽тɃ_Ȓlɏ)
    $game_system.magic_number = $data_system.magic_number
    # eQ[IuWFNg
    Marshal.dump($game_system, file)
    Marshal.dump($game_switches, file)
    Marshal.dump($game_variables, file)
    Marshal.dump($game_self_switches, file)
    Marshal.dump($game_screen, file)
    Marshal.dump($game_actors, file)
    Marshal.dump($game_party, file)
    Marshal.dump($game_troop, file)
    Marshal.dump($game_map, file)
    Marshal.dump($game_player, file)
  end
end
